// src/geometry.rs

pub fn colored_square_vertices() -> [f32; 36] {
    [
//         x,    y,    z,    r,    g,    b
        -1.0,  1.0,  1.0,  0.0,  1.0,  0.0,  // Top-left
         1.0,  1.0,  1.0,  1.0,  1.0,  0.0,  // Top-right
        -1.0, -1.0,  1.0,  0.0,  0.0,  0.0,  // Bottom-left
         1.0,  1.0,  1.0,  1.0,  1.0,  0.0,  // Top-right
         1.0, -1.0,  1.0,  1.0,  0.0,  0.0,  // Bottom-right
        -1.0, -1.0,  1.0,  0.0,  0.0,  0.0,  // Bottom-left
    ]
}

pub fn scale_mat3(tx: f32, ty: f32) -> [f32; 9] {
    [
         tx, 0.0, 0.0,
        0.0,  ty, 0.0,
        0.0, 0.0, 1.0,
    ]
} 

pub fn translate_mat3(tx: f32, ty: f32) -> [f32; 9] {
    [
        1.0, 0.0, 0.0,
        0.0, 1.0, 0.0,
         tx,  ty, 1.0,
    ]
}

pub fn one_point_perspective_mat3(x: f32, y: f32, z: f32) -> [f32; 9] {
    // 2.5D paralax and scale; no rotation
    let b = 1.0;
    let s = 1.0 / (z + b);

    [
          s, 0.0, 0.0,
        0.0,   s, 0.0,
        x*s, y*s, 1.0,
    ]
}
